# Scriptra Chrome Extension

Quick content creation tools for social media creators.

## Features

- **📊 Character Counter** - Count characters for any platform (Twitter, LinkedIn, Instagram, etc.)
- **📝 Quick Templates** - Pre-made templates for engagement, promotional, educational, and storytelling posts
- **🏷️ Hashtag Generator** - Generate relevant hashtags by topic
- **😀 Emoji Picker** - Quick access to categorized emojis
- **💾 Draft Saver** - Save and manage your content drafts
- **🔢 Auto Counter on Sites** - Automatic character counter on Twitter, LinkedIn, Instagram, and more

## Installation

### From Source (Development)

1. Open Chrome and go to `chrome://extensions/`
2. Enable "Developer mode" (toggle in top right)
3. Click "Load unpacked"
4. Select the `chrome-extension` folder
5. The extension icon should appear in your toolbar

### Adding Icons

Before publishing, add proper icons to the `icons` folder:

- `icon16.png` (16x16 pixels)
- `icon32.png` (32x32 pixels)
- `icon48.png` (48x48 pixels)
- `icon128.png` (128x128 pixels)

You can copy the logo from the main app:
```bash
# From project root
cp public/logo.png chrome-extension/icons/icon128.png
# Then resize for other sizes using ImageMagick or similar
```

## Usage

### Popup Tools

1. Click the Scriptra icon in your toolbar
2. Use the tabs to access different tools:
   - **Counter**: Paste content and see character/word count
   - **Templates**: Browse and copy pre-made templates
   - **Hashtags**: Generate hashtags by topic
   - **Emoji**: Quick emoji picker with categories
   - **Drafts**: Access saved drafts

### On Social Media Sites

The extension automatically adds a character counter to text fields on:
- Twitter/X
- LinkedIn
- Instagram
- Facebook
- Threads

### Right-Click Menu

Select any text on a webpage, right-click, and choose:
- "Count characters with Scriptra" - Get character/word count
- "Save to Scriptra drafts" - Save selection as draft

## Development

### File Structure

```
chrome-extension/
├── manifest.json       # Extension configuration
├── popup.html         # Popup UI
├── popup.css          # Popup styles
├── popup.js           # Popup logic
├── icons/             # Extension icons
│   ├── icon16.png
│   ├── icon32.png
│   ├── icon48.png
│   └── icon128.png
└── src/
    ├── background.js  # Background service worker
    ├── content.js     # Content script for social sites
    └── content.css    # Content script styles
```

### Building for Production

1. Ensure all icons are in place
2. Remove any console.log statements
3. Test on all supported platforms
4. Zip the extension folder
5. Upload to Chrome Web Store

## Permissions

- `storage` - Save drafts and settings
- `clipboardWrite` - Copy content to clipboard
- `activeTab` - Access current tab for character counting
- Content script access to social media sites

## Privacy

This extension:
- Does NOT collect any personal data
- Does NOT send data to external servers
- Stores all data locally in your browser
- Only runs on specified social media sites

## Support

For issues or feature requests, visit:
https://scriptra.app/support

---

Built with ❤️ by Scriptra

